/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.class_1160;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3443;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_4966;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7151;

public class MineshaftEndStructure
extends class_3195 {
    public static final Codec<MineshaftEndStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MineshaftEndStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.optionalFieldOf("min_y_allowed").forGetter(structure -> structure.minYAllowed), (App)Codec.INT.optionalFieldOf("max_y_allowed").forGetter(structure -> structure.maxYAllowed), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_y_range_from_start").forGetter(structure -> structure.allowedYRangeFromStart), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)class_2960.field_25139.listOf().fieldOf("pools_that_ignore_boundaries").orElse(new ArrayList()).xmap(HashSet::new, ArrayList::new).forGetter(structure -> structure.poolsThatIgnoreBoundaries), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("min_island_thickness_allowed").forGetter(config -> config.minIslandThickness)).apply((Applicative)instance, MineshaftEndStructure::new));
    public final class_6880<class_3785> startPool;
    public final int size;
    public final Optional<Integer> minYAllowed;
    public final Optional<Integer> maxYAllowed;
    public final Optional<Integer> allowedYRangeFromStart;
    public final class_6122 startHeight;
    public final Optional<Integer> biomeRadius;
    public final HashSet<class_2960> poolsThatIgnoreBoundaries;
    public final Optional<Integer> maxDistanceFromCenter;
    public final Optional<Integer> minIslandThickness;

    public MineshaftEndStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, int size, Optional<Integer> minYAllowed, Optional<Integer> maxYAllowed, Optional<Integer> allowedYRangeFromStart, class_6122 startHeight, Optional<Integer> biomeRadius, HashSet<class_2960> poolsThatIgnoreBoundaries, Optional<Integer> maxDistanceFromCenter, Optional<Integer> minIslandThickness) {
        super(config);
        this.startPool = startPool;
        this.size = size;
        this.minYAllowed = minYAllowed;
        this.maxYAllowed = maxYAllowed;
        this.allowedYRangeFromStart = allowedYRangeFromStart;
        this.startHeight = startHeight;
        this.biomeRadius = biomeRadius;
        this.poolsThatIgnoreBoundaries = poolsThatIgnoreBoundaries;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.minIslandThickness = minIslandThickness;
        if (maxYAllowed.isPresent() && minYAllowed.isPresent() && maxYAllowed.get() < minYAllowed.get()) {
            throw new RuntimeException("    Repurposed Structures: maxYAllowed cannot be less than minYAllowed.\n    Please correct this error as there's no way to spawn this structure properly\n        Structure pool of problematic structure: %s\n".formatted(((class_3785)startPool.comp_349()).method_16629()));
        }
    }

    protected boolean extraSpawningChecks(class_3195.class_7149 context, class_2338 blockPos) {
        if (this.minIslandThickness.isEmpty()) {
            return true;
        }
        class_2338.class_2339 islandTopBottomThickness = new class_2338.class_2339(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        int xPos = blockPos.method_10263();
        int zPos = blockPos.method_10260();
        int landHeight = Integer.MAX_VALUE;
        for (int i = 2; i >= 1; --i) {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_1160 offsetPos = direction.method_23955();
                offsetPos.method_4942(30.0f * (float)i);
                landHeight = MineshaftEndStructure.getHeightAt(context, xPos + (int)offsetPos.method_4943(), zPos + (int)offsetPos.method_4947(), landHeight);
                if (landHeight - context.comp_562().method_33730() >= this.minIslandThickness.get()) continue;
                return false;
            }
        }
        MineshaftEndStructure.analyzeLand(context, xPos, zPos, islandTopBottomThickness, context.comp_569());
        return islandTopBottomThickness.method_10260() >= this.minIslandThickness.get();
    }

    private static int getHeightAt(class_3195.class_7149 context, int xPos, int zPos, int landHeight) {
        landHeight = Math.min(landHeight, context.comp_562().method_18028(xPos, zPos, class_2902.class_2903.field_13194, context.comp_569(), context.comp_564()));
        return landHeight;
    }

    private static void analyzeLand(class_3195.class_7149 context, int xPos, int zPos, class_2338.class_2339 islandTopBottomThickness, class_5539 heightLimitView) {
        class_4966 columnOfBlocks = context.comp_562().method_26261(xPos, zPos, heightLimitView, context.comp_564());
        int minY = context.comp_562().method_33730();
        int rangeHeight = GeneralUtils.getMaxTerrainLimit(context.comp_562());
        int maxY = minY + rangeHeight;
        class_2338.class_2339 currentPos = new class_2338.class_2339(xPos, maxY, zPos);
        boolean isInIsland = false;
        while (currentPos.method_10264() >= minY) {
            class_2680 state = columnOfBlocks.method_32892(currentPos.method_10264());
            if (!state.method_26215() && !isInIsland) {
                isInIsland = true;
                int topIslandY = Math.min(currentPos.method_10264(), islandTopBottomThickness.method_10263());
                islandTopBottomThickness.method_10103(topIslandY, islandTopBottomThickness.method_10264(), islandTopBottomThickness.method_10260());
            } else if (state.method_26215() && isInIsland || currentPos.method_10264() == minY) {
                int bottomIslandY = Math.max(currentPos.method_10264(), islandTopBottomThickness.method_10264());
                islandTopBottomThickness.method_10103(islandTopBottomThickness.method_10263(), bottomIslandY, islandTopBottomThickness.method_10260());
                break;
            }
            currentPos.method_10098(class_2350.field_11033);
        }
        if (!isInIsland) {
            islandTopBottomThickness.method_10103(0, 0, 0);
        }
        int thickness = islandTopBottomThickness.method_10263() - islandTopBottomThickness.method_10264();
        islandTopBottomThickness.method_10103(islandTopBottomThickness.method_10263(), islandTopBottomThickness.method_10264(), thickness);
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_2338.class_2339 blockpos = new class_2338.class_2339(context.comp_568().method_8326(), 0, context.comp_568().method_8328());
        if (!this.extraSpawningChecks(context, (class_2338)blockpos)) {
            return Optional.empty();
        }
        class_2338.class_2339 islandTopBottomThickness = new class_2338.class_2339(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        MineshaftEndStructure.analyzeLand(context, blockpos.method_10263(), blockpos.method_10260(), islandTopBottomThickness, context.comp_569());
        int maxY = 53;
        int minY = 15;
        if (this.minIslandThickness.isEmpty()) {
            blockpos.method_10104(class_2350.field_11036, 35);
        } else {
            class_2919 random = new class_2919((class_5819)new class_5820(0L));
            random.method_12663(context.comp_567(), context.comp_568().field_9181, context.comp_568().field_9180);
            int structureStartHeight = random.method_43048(Math.max(islandTopBottomThickness.method_10260() - this.minIslandThickness.get() + 1, 1)) + islandTopBottomThickness.method_10264() + this.minIslandThickness.get() / 2;
            blockpos.method_10104(class_2350.field_11036, structureStartHeight);
            maxY = islandTopBottomThickness.method_10263() - 10;
            minY = islandTopBottomThickness.method_10264();
            if (maxY - minY <= 10) {
                minY = maxY - 10;
            }
        }
        int finalMaxY = maxY;
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, this.startPool, this.size, context.comp_561().method_30530(class_2378.field_25915).method_10221((Object)this), (class_2338)blockpos, false, Optional.empty(), maxY, minY, this.poolsThatIgnoreBoundaries, this.maxDistanceFromCenter, Optional.empty(), (structurePiecesBuilder, pieces) -> {
            Optional<class_3790> highestPiece = pieces.stream().max(Comparator.comparingInt(p -> p.method_14935().method_35419()));
            int topY = highestPiece.map(poolElementStructurePiece -> poolElementStructurePiece.method_14935().method_35419()).orElseGet(() -> ((class_2338.class_2339)blockpos).method_10264());
            if (topY > finalMaxY) {
                int newOffset = finalMaxY - topY;
                for (class_3443 piece : pieces) {
                    piece.method_14922(0, newOffset, 0);
                }
            }
        });
    }

    public class_7151<?> method_41618() {
        return RSStructures.MINESHAFT_END;
    }
}

